/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.CreateEventLogData;
import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.base.logd.LogDisplayer;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.logd.SystemEventBean;
import com.ibm.hwmca.base.logd.SystemEventInfo;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.logd.DisplayerExpander;
import com.ibm.hwmca.fw.logd.DisplayerExpanderData;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Locale;
import java.util.MissingResourceException;

public class SystemEventExpanderTasklet
extends DisplayerExpander
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDEYT";
    private static final String TRACE_MASKF = "XLOGDEYF";
    private static final String TRACE_MASKD = "XLOGDEYD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.logd.res.LogDisplayerRes";
    private static final String SYSTEM_EVENT_NAME = "SystemEventPanel";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    CreateEventLogData _createEventLogData = new CreateEventLogData();

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        block15: {
            Trace.trace(TRACE_MASKT, "-> SystemEventExpanderTasklet.service()");
            if (taskletRequest.isInitialRequest()) {
                Trace.trace(TRACE_MASKF, "SystemEventExpanderTasklet - doing InitialRequest");
                super.service(taskletRequest, taskletResponse);
                DisplayerExpanderData displayerExpanderData = super.getData();
                if (!taskletResponse.isResponseSet()) {
                    Log log = displayerExpanderData.getLogData();
                    SystemEventLog systemEventLog = new SystemEventLog(log);
                    String key = systemEventLog.getEventText().getKey();
                    Trace.trace(TRACE_MASKF, "system event KEY=[" + key + "]");
                    UserContext userContext = UserContext.getCurrentUserContext();
                    Locale locale = userContext.getLocale();
                    if (locale == null) {
                        Trace.trace(TRACE_MASKF, "LOCALE IS NULL");
                    }
                    try {
                        String msg = systemEventLog.getEventText().toString(locale);
                        if (msg.equals(key)) {
                            Trace.trace(TRACE_MASKF, "system event and the key are equal. SysEvent msg not found");
                            LocalizableText lSystemEvent = new LocalizableText(BaseTextBundle.getBundleName(), "logd.sysevent.title");
                            BaseMessageText myMess = new BaseMessageText("LOGNSYSM");
                            this.showMessageBox(true, lSystemEvent, myMess, null, null);
                            taskletResponse.dispose();
                            break block15;
                        }
                        EventLogData eventLogData = this._createEventLogData.createEventLogData(log);
                        Trace.trace(TRACE_MASKF, "System event=" + systemEventLog.getEventText());
                        SystemEventBean systemEventBean = new SystemEventBean();
                        SystemEventInfo systemEventInfo = new SystemEventInfo(eventLogData, msg);
                        systemEventBean.setSystemEventInfo(systemEventInfo);
                        Trace.trace(TRACE_MASKF, "Display system eventdata");
                        taskletResponse.openModalChild(AUIML_FILE_NAME, SYSTEM_EVENT_NAME, systemEventBean);
                    }
                    catch (MissingResourceException mrb) {
                        Trace.trace(TRACE_MASKF, mrb);
                        BaseMessageText myMess = new BaseMessageText("LOGNRB");
                        LocalizableText lSystemEvent = new LocalizableText(BaseTextBundle.getBundleName(), "logd.sysevent.title");
                        this.showMessageBox(true, lSystemEvent, myMess, null, null);
                        new FrameworkLog(_logInfo, 1371, mrb).log(FrameworkLogAttributes.INFO_LOG);
                        taskletResponse.dispose();
                    }
                }
            } else if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
                Trace.trace(TRACE_MASKF, "before the log terminate");
                taskletResponse.terminate();
            } else {
                String panelError = (String)taskletRequest.getData("panelError");
                if (panelError == null) {
                    TaskActionEvent event = (TaskActionEvent)taskletRequest.getData("event");
                    String command = event.getActionCommand();
                    Trace.trace(TRACE_MASKF, "SystemEvent's command =" + command);
                    if (command.equals("OkButton")) {
                        taskletResponse.dispose();
                    } else if (command.equals("CANCEL")) {
                        taskletResponse.dispose();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received by the SystemEventExpander panel. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "SystemEventExpanderTasklet panelErr=" + panelError);
                    taskletResponse.terminate();
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- SystemEventExpanderTasklet.service()");
    }

    public void logException(Throwable e) {
        Trace.trace(TRACE_MASKT, "-> SystemEventExpanderTasklet.logException()");
        Trace.trace(TRACE_MASKF, e);
        new FrameworkLog(_logInfo, 1363, e).log();
        Trace.trace(TRACE_MASKT, "<- SystemEventExpanderTasklet.logException()");
    }
}

